/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.vanilla;

import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rlmixins.wrapper.SMEWrapper;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    private static final UUID SS_UUID = UUID.fromString("fc1c8dca-9411-4a4e-97a4-90e66c883a77");
    private static final UUID HW_UUID = UUID.fromString("e2765897-134f-4c14-a535-29c3ae5c7a21");

    @Inject(method={"getAttributeModifiers"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    public void rlmixins_vanillaItem_getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack, CallbackInfoReturnable<Multimap<String, AttributeModifier>> cir) {
        if (stack.func_190926_b() || slot != EntityEquipmentSlot.MAINHAND) {
            return;
        }
        Multimap map = (Multimap)cir.getReturnValue();
        int ssLevel = EnchantmentHelper.func_77506_a((Enchantment)SMEWrapper.getSwifterSlashes(), (ItemStack)stack);
        int hwLevel = EnchantmentHelper.func_77506_a((Enchantment)SMEWrapper.getHeavyWeight(), (ItemStack)stack);
        if (ssLevel > 0) {
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(SS_UUID, "swifterSlashes", 0.2 * (double)ssLevel, 1));
        }
        if (hwLevel > 0) {
            map.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(HW_UUID, "heavyWeight", ((double)hwLevel * 0.1 + 0.2) * -1.0, 1));
        }
        cir.setReturnValue((Object)map);
    }
}

